/*
 * ALKIS-Container: Relationsbildung
 *      zwischen "liegeo__alkis_container"."st_alkis" und "liegeo"."tbl_data_flurstueck"
 *
 * Übernahme von Flurstück-Information und -Geometrien
 * aus "liegeo__alkis_container"."st_alkis" und "liegeo"."tbl_data_flurstueck"
 * nach "liegeo"."st_liegeo"
 *
 * Stamm-Db: "liegeo"
 *
 * @author: Bernd Marcus
 * @date: 2024-05-14
 * @copyrigth: CreativeCommens ???
 *
 *** Revision ***
 * - 07.01.2025: Gemarkungsumringung wird in "st_alkis" generiert
 * - 15.08.2025: Integration geometrieloser LieMaS-Einträge in "st_liegeo"
 * - 27.08.2025: Übernahme von "gueltig_von" und "alkis_import" nach "st_liegeo" aus "st_alkis"
 */

BEGIN;

/*
 * Entwicklung mit CLI: Verbindungsstring LieGeo ALKIS-Container
 *
 * -- Db "cont" wird über `alkisimport.py` des LieGeo-Plugins eingebunden
 * attach database ('C:/LieMaS_Geo_dev/liegeo_admin_tools/liegeo__alkis_container/data/liegeo__alkis_container.sqlite') as cont;
 */

-- Leeren von "st_liegeo"
DELETE from st_liegeo;

--------------------------------------------------
--LieMaS-Flurstücke / ALKIS-Container
--------------------------------------------------
-- Relation aller Flurstücke mit Eigentum oder Besitz zu ALKIS-Daten
--- unabhängig von Treffer oder nicht
drop view if exists "tv_lieflst_ljoin_alkis";
create temp view "tv_lieflst_ljoin_alkis" as
select
    a.lfdnr
    -- pk zeigt Bindungstärke:
    -- not NULL = Flurstück
    -- is NULL  = Gemarkung
    , b.pk
    , a.flstkennz
    --, b.fk_flstkennz_liemas
    -- , a.gema_nr
    , b.relation
    , b.gueltig_von, b.alkis_import
    , b.geom
from v_sys_flstkennz as a
left join cont.st_alkis as b
--on a.flstkennz == b.fk_flstkennz_liemas
-- Änderung 18.08.25
-- Flurstücke mit Folgemerkmal:
-- veraltete Geometrien erhalten Ungültigkeitstempen in "wfs_download_alkis.py"
-- somit eindeutige Beziehung über "flstkennz" ohne Folge
on substr(a.flstkennz, 1,18) == substr(b.fk_flstkennz_liemas, 1,18)
where 1
and b.gueltig_bis is NULL
;


-- Befüllen: Flurstücke
insert into st_liegeo(
    pk
    , flstkennz, bundesland, landkreis, gemeinde, gemarkung_nr, gemarkung
    , flur, zaehler, nenner, folge, amtl_flaeche
    , restriktion, gebiet, projekt, projektbeginn, projektende
    , bezirk, wirtschaftsart, ackerzahl, gruenlandzahl, verkehrssicherungspflicht, vsp_bemerkung
    , eigentum_kategorie, eigentum_organisation, eigentum_kuerzel, eigentum_anzahl
    , besitz_kategorie, besitz_organisation, besitz_kuerzel, besitz_anzahl
    , pacht_aktenzeichen, pacht_vertragsart, pacht_anzahl, pacht_aktenzeichen_id
    , pacht_lawi_aktenzeichen, pacht_lawi_vertragsart, pacht_lawi_anzahl
    , pacht_jagd_aktenzeichen, pacht_jagd_vertragsart, pacht_jagd_anzahl
    , pacht_frei_aktenzeichen, pacht_frei_vertragsart, pacht_frei_anzahl
    , pacht_sonst_aktenzeichen, pacht_sonst_vertragsart, pacht_sonst_anzahl
    , nutzung, nutzung_anzahl, nutzart, nutzart_anzahl, nutzart_nne, nutzart_nne_anzahl
    , kaufentwurf_aktenzeichen, kaufentwurf_status, kaufentwurf_vertragsart, kaufentwurf_anzahl, kaufentwurf_aktenzeichen_id
    , kaufvertrag_aktenzeichen, kaufvertrag_vertragsart, kaufvertrag_anzahl, kaufvertrag_aktenzeichen_id
    , verkaufentwurf_aktenzeichen, verkaufentwurf_status, verkaufentwurf_vertragsart, verkaufentwurf_anzahl
    , verkaufvertrag_aktenzeichen, verkaufvertrag_vertragsart, verkaufvertrag_anzahl
    , liste_eigentum_kategorie, liste_eigentum_organisation, liste_eigentum_kuerzel
    , liste_besitz_kategorie, liste_besitz_organisation, liste_besitz_kuerzel
    , liste_pacht_aktenzeichen, liste_pacht_vertragsart
    , liste_pacht_lawi_vertragsart, liste_pacht_jagd_vertragsart, liste_pacht_frei_vertragsart, liste_pacht_sonst_vertragsart
    , liste_nutzung, liste_nutzart, liste_nutzart_nne
    , liste_kaufentwurf_aktenzeichen, liste_kaufentwurf_vertragsart, liste_kaufentwurf_status
    , liste_kaufvertrag_aktenzeichen, liste_kaufvertrag_vertragsart
    , liste_verkaufentwurf_aktenzeichen, liste_verkaufentwurf_vertragsart, liste_verkaufentwurf_status
    , liste_verkaufvertrag_aktenzeichen, liste_verkaufvertrag_vertragsart
    , relation
    , gueltig_von, alkis_import
    , geom
)
with
-- Relation: Geome und Flurstücksinformation
flst as (
    select lfdnr
        -- , pk, flstkennz
        , relation
        , gueltig_von, alkis_import
        , geom
        from tv_lieflst_ljoin_alkis
        where true
        -- Flurstücksebene
        and pk not NULL
)
select a.lfdnr
    , b.flstkennz, b.bundesland, b.landkreis, b.gemeinde, b.gemarkung_nr, b.gemarkung
    , b.flur, b.zaehler, b.nenner, b.folge, b.amtl_flaeche
    , b.restriktion, b.gebiet, b.projekt, b.projektbeginn, b.projektende
    , b.bezirk, b.wirtschaftsart, b.ackerzahl, b.gruenlandzahl, b.verkehrssicherungspflicht, b.vsp_bemerkung
    , b.eigentum_kategorie, b.eigentum_organisation, b.eigentum_kuerzel, b.eigentum_anzahl
    , b.besitz_kategorie, b.besitz_organisation, b.besitz_kuerzel, b.besitz_anzahl
    , b.pacht_aktenzeichen, b.pacht_vertragsart, b.pacht_anzahl, b.pacht_aktenzeichen_id
    , b.pacht_lawi_aktenzeichen, b.pacht_lawi_vertragsart, b.pacht_lawi_anzahl
    , b.pacht_jagd_aktenzeichen, b.pacht_jagd_vertragsart, b.pacht_jagd_anzahl
    , b.pacht_frei_aktenzeichen, b.pacht_frei_vertragsart, b.pacht_frei_anzahl
    , b.pacht_sonst_aktenzeichen, b.pacht_sonst_vertragsart, b.pacht_sonst_anzahl
    , b.nutzung, b.nutzung_anzahl, b.nutzart, b.nutzart_anzahl, b.nutzart_nne, b.nutzart_nne_anzahl
    , b.kaufentwurf_aktenzeichen, b.kaufentwurf_status, b.kaufentwurf_vertragsart, b.kaufentwurf_anzahl, b.kaufentwurf_aktenzeichen_id
    , b.kaufvertrag_aktenzeichen, b.kaufvertrag_vertragsart, b.kaufvertrag_anzahl, b.kaufvertrag_aktenzeichen_id
    , b.verkaufentwurf_aktenzeichen, b.verkaufentwurf_status, b.verkaufentwurf_vertragsart, b.verkaufentwurf_anzahl
    , b.verkaufvertrag_aktenzeichen, b.verkaufvertrag_vertragsart, b.verkaufvertrag_anzahl
    , b.liste_eigentum_kategorie, b.liste_eigentum_organisation, b.liste_eigentum_kuerzel
    , b.liste_besitz_kategorie, b.liste_besitz_organisation, b.liste_besitz_kuerzel
    , b.liste_pacht_aktenzeichen, b.liste_pacht_vertragsart
    , b.liste_pacht_lawi_vertragsart, b.liste_pacht_jagd_vertragsart, b.liste_pacht_frei_vertragsart, b.liste_pacht_sonst_vertragsart
    , b.liste_nutzung, b.liste_nutzart, b.liste_nutzart_nne
    , b.liste_kaufentwurf_aktenzeichen, b.liste_kaufentwurf_vertragsart, b.liste_kaufentwurf_status
    , b.liste_kaufvertrag_aktenzeichen, b.liste_kaufvertrag_vertragsart
    , b.liste_verkaufentwurf_aktenzeichen, b.liste_verkaufentwurf_vertragsart, b.liste_verkaufentwurf_status
    , b.liste_verkaufvertrag_aktenzeichen, b.liste_verkaufvertrag_vertragsart
    , a.relation
    , a.gueltig_von, a.alkis_import
    , a.geom
from flst as a
join v_joinp_all as b
on a.lfdnr == b.fk_td_flurstueck__lfdnr
order by a.lfdnr
;

-- Befüllen: Gemarkungen
insert into st_liegeo(
    pk
    , flstkennz, bundesland, landkreis, gemeinde, gemarkung_nr, gemarkung
    , flur, zaehler, nenner, folge, amtl_flaeche
    , restriktion, gebiet, projekt, projektbeginn, projektende
    , bezirk, wirtschaftsart, ackerzahl, gruenlandzahl, verkehrssicherungspflicht, vsp_bemerkung
    , eigentum_kategorie, eigentum_organisation, eigentum_kuerzel, eigentum_anzahl
    , besitz_kategorie, besitz_organisation, besitz_kuerzel, besitz_anzahl
    , pacht_aktenzeichen, pacht_vertragsart, pacht_anzahl, pacht_aktenzeichen_id
    , pacht_lawi_aktenzeichen, pacht_lawi_vertragsart, pacht_lawi_anzahl
    , pacht_jagd_aktenzeichen, pacht_jagd_vertragsart, pacht_jagd_anzahl
    , pacht_frei_aktenzeichen, pacht_frei_vertragsart, pacht_frei_anzahl
    , pacht_sonst_aktenzeichen, pacht_sonst_vertragsart, pacht_sonst_anzahl
    , nutzung, nutzung_anzahl, nutzart, nutzart_anzahl, nutzart_nne, nutzart_nne_anzahl
    , kaufentwurf_aktenzeichen, kaufentwurf_status, kaufentwurf_vertragsart, kaufentwurf_anzahl, kaufentwurf_aktenzeichen_id
    , kaufvertrag_aktenzeichen, kaufvertrag_vertragsart, kaufvertrag_anzahl, kaufvertrag_aktenzeichen_id
    , verkaufentwurf_aktenzeichen, verkaufentwurf_status, verkaufentwurf_vertragsart, verkaufentwurf_anzahl
    , verkaufvertrag_aktenzeichen, verkaufvertrag_vertragsart, verkaufvertrag_anzahl
    , liste_eigentum_kategorie, liste_eigentum_organisation, liste_eigentum_kuerzel
    , liste_besitz_kategorie, liste_besitz_organisation, liste_besitz_kuerzel
    , liste_pacht_aktenzeichen, liste_pacht_vertragsart
    , liste_pacht_lawi_vertragsart, liste_pacht_jagd_vertragsart, liste_pacht_frei_vertragsart, liste_pacht_sonst_vertragsart
    , liste_nutzung, liste_nutzart, liste_nutzart_nne
    , liste_kaufentwurf_aktenzeichen, liste_kaufentwurf_vertragsart, liste_kaufentwurf_status
    , liste_kaufvertrag_aktenzeichen, liste_kaufvertrag_vertragsart
    , liste_verkaufentwurf_aktenzeichen, liste_verkaufentwurf_vertragsart, liste_verkaufentwurf_status
    , liste_verkaufvertrag_aktenzeichen, liste_verkaufvertrag_vertragsart
    , relation
    , alkis_import
    , geom
)
with
-- Relation: Geome und Flurstücksinformation
gema as (
    select a.lfdnr
        -- , a.flstkennz
        , b.relation
        , b.alkis_import
        , b.geom
    from tv_lieflst_ljoin_alkis as a
    join cont.st_alkis as b
    --on substr(a.flstkennz,1,6) == b.flstkennz
    -- Änderung 21.08.25:
    -- Abspecken von "st_alkis": "flstkennz" obsolet
    -- Gemarkungsschlüssel wird nach "fk_flstkennz_liemas" übertragen
    on substr(a.flstkennz,1,6) == b.fk_flstkennz_liemas
    where true
    -- Gemarkungsebene
    and a.pk is NULL
)
select a.lfdnr
    , b.flstkennz, b.bundesland, b.landkreis, b.gemeinde, b.gemarkung_nr, b.gemarkung
    , b.flur, b.zaehler, b.nenner, b.folge, b.amtl_flaeche
    , b.restriktion, b.gebiet, b.projekt, b.projektbeginn, b.projektende
    , b.bezirk, b.wirtschaftsart, b.ackerzahl, b.gruenlandzahl, b.verkehrssicherungspflicht, b.vsp_bemerkung
    , b.eigentum_kategorie, b.eigentum_organisation, b.eigentum_kuerzel, b.eigentum_anzahl
    , b.besitz_kategorie, b.besitz_organisation, b.besitz_kuerzel, b.besitz_anzahl
    , b.pacht_aktenzeichen, b.pacht_vertragsart, b.pacht_anzahl, b.pacht_aktenzeichen_id
    , b.pacht_lawi_aktenzeichen, b.pacht_lawi_vertragsart, b.pacht_lawi_anzahl
    , b.pacht_jagd_aktenzeichen, b.pacht_jagd_vertragsart, b.pacht_jagd_anzahl
    , b.pacht_frei_aktenzeichen, b.pacht_frei_vertragsart, b.pacht_frei_anzahl
    , b.pacht_sonst_aktenzeichen, b.pacht_sonst_vertragsart, b.pacht_sonst_anzahl
    , b.nutzung, b.nutzung_anzahl, b.nutzart, b.nutzart_anzahl, b.nutzart_nne, b.nutzart_nne_anzahl
    , b.kaufentwurf_aktenzeichen, b.kaufentwurf_status, b.kaufentwurf_vertragsart, b.kaufentwurf_anzahl, b.kaufentwurf_aktenzeichen_id
    , b.kaufvertrag_aktenzeichen, b.kaufvertrag_vertragsart, b.kaufvertrag_anzahl, b.kaufvertrag_aktenzeichen_id
    , b.verkaufentwurf_aktenzeichen, b.verkaufentwurf_status, b.verkaufentwurf_vertragsart, b.verkaufentwurf_anzahl
    , b.verkaufvertrag_aktenzeichen, b.verkaufvertrag_vertragsart, b.verkaufvertrag_anzahl
    , b.liste_eigentum_kategorie, b.liste_eigentum_organisation, b.liste_eigentum_kuerzel
    , b.liste_besitz_kategorie, b.liste_besitz_organisation, b.liste_besitz_kuerzel
    , b.liste_pacht_aktenzeichen, b.liste_pacht_vertragsart
    , b.liste_pacht_lawi_vertragsart, b.liste_pacht_jagd_vertragsart, b.liste_pacht_frei_vertragsart, b.liste_pacht_sonst_vertragsart
    , b.liste_nutzung, b.liste_nutzart, b.liste_nutzart_nne
    , b.liste_kaufentwurf_aktenzeichen, b.liste_kaufentwurf_vertragsart, b.liste_kaufentwurf_status
    , b.liste_kaufvertrag_aktenzeichen, b.liste_kaufvertrag_vertragsart
    , b.liste_verkaufentwurf_aktenzeichen, b.liste_verkaufentwurf_vertragsart, b.liste_verkaufentwurf_status
    , b.liste_verkaufvertrag_aktenzeichen, b.liste_verkaufvertrag_vertragsart
    , a.relation
    , a.alkis_import
    , a.geom
from gema as a
join v_joinp_all as b
on a.lfdnr == b.fk_td_flurstueck__lfdnr
order by a.lfdnr
;


-- Flächeninformation ohne verknüpfbare Geometrie von Flurstück oder Gemarkung
insert into st_liegeo(
    pk
    , flstkennz, bundesland, landkreis, gemeinde, gemarkung_nr, gemarkung
    , flur, zaehler, nenner, folge, amtl_flaeche
    , restriktion, gebiet, projekt, projektbeginn, projektende
    , bezirk, wirtschaftsart, ackerzahl, gruenlandzahl, verkehrssicherungspflicht, vsp_bemerkung
    , eigentum_kategorie, eigentum_organisation, eigentum_kuerzel, eigentum_anzahl
    , besitz_kategorie, besitz_organisation, besitz_kuerzel, besitz_anzahl
    , pacht_aktenzeichen, pacht_vertragsart, pacht_anzahl, pacht_aktenzeichen_id
    , pacht_lawi_aktenzeichen, pacht_lawi_vertragsart, pacht_lawi_anzahl
    , pacht_jagd_aktenzeichen, pacht_jagd_vertragsart, pacht_jagd_anzahl
    , pacht_frei_aktenzeichen, pacht_frei_vertragsart, pacht_frei_anzahl
    , pacht_sonst_aktenzeichen, pacht_sonst_vertragsart, pacht_sonst_anzahl
    , nutzung, nutzung_anzahl, nutzart, nutzart_anzahl, nutzart_nne, nutzart_nne_anzahl
    , kaufentwurf_aktenzeichen, kaufentwurf_status, kaufentwurf_vertragsart, kaufentwurf_anzahl, kaufentwurf_aktenzeichen_id
    , kaufvertrag_aktenzeichen, kaufvertrag_vertragsart, kaufvertrag_anzahl, kaufvertrag_aktenzeichen_id
    , verkaufentwurf_aktenzeichen, verkaufentwurf_status, verkaufentwurf_vertragsart, verkaufentwurf_anzahl
    , verkaufvertrag_aktenzeichen, verkaufvertrag_vertragsart, verkaufvertrag_anzahl
    , liste_eigentum_kategorie, liste_eigentum_organisation, liste_eigentum_kuerzel
    , liste_besitz_kategorie, liste_besitz_organisation, liste_besitz_kuerzel
    , liste_pacht_aktenzeichen, liste_pacht_vertragsart
    , liste_pacht_lawi_vertragsart, liste_pacht_jagd_vertragsart, liste_pacht_frei_vertragsart, liste_pacht_sonst_vertragsart
    , liste_nutzung, liste_nutzart, liste_nutzart_nne
    , liste_kaufentwurf_aktenzeichen, liste_kaufentwurf_vertragsart, liste_kaufentwurf_status
    , liste_kaufvertrag_aktenzeichen, liste_kaufvertrag_vertragsart
    , liste_verkaufentwurf_aktenzeichen, liste_verkaufentwurf_vertragsart, liste_verkaufentwurf_status
    , liste_verkaufvertrag_aktenzeichen, liste_verkaufvertrag_vertragsart
    , relation
    , geom
)
select b.fk_td_flurstueck__lfdnr
    , b.flstkennz, b.bundesland, b.landkreis, b.gemeinde, b.gemarkung_nr, b.gemarkung
    , b.flur, b.zaehler, b.nenner, b.folge, b.amtl_flaeche
    , b.restriktion, b.gebiet, b.projekt, b.projektbeginn, b.projektende
    , b.bezirk, b.wirtschaftsart, b.ackerzahl, b.gruenlandzahl, b.verkehrssicherungspflicht, b.vsp_bemerkung
    , b.eigentum_kategorie, b.eigentum_organisation, b.eigentum_kuerzel, b.eigentum_anzahl
    , b.besitz_kategorie, b.besitz_organisation, b.besitz_kuerzel, b.besitz_anzahl
    , b.pacht_aktenzeichen, b.pacht_vertragsart, b.pacht_anzahl, b.pacht_aktenzeichen_id
    , b.pacht_lawi_aktenzeichen, b.pacht_lawi_vertragsart, b.pacht_lawi_anzahl
    , b.pacht_jagd_aktenzeichen, b.pacht_jagd_vertragsart, b.pacht_jagd_anzahl
    , b.pacht_frei_aktenzeichen, b.pacht_frei_vertragsart, b.pacht_frei_anzahl
    , b.pacht_sonst_aktenzeichen, b.pacht_sonst_vertragsart, b.pacht_sonst_anzahl
    , b.nutzung, b.nutzung_anzahl, b.nutzart, b.nutzart_anzahl, b.nutzart_nne, b.nutzart_nne_anzahl
    , b.kaufentwurf_aktenzeichen, b.kaufentwurf_status, b.kaufentwurf_vertragsart, b.kaufentwurf_anzahl, b.kaufentwurf_aktenzeichen_id
    , b.kaufvertrag_aktenzeichen, b.kaufvertrag_vertragsart, b.kaufvertrag_anzahl, b.kaufvertrag_aktenzeichen_id
    , b.verkaufentwurf_aktenzeichen, b.verkaufentwurf_status, b.verkaufentwurf_vertragsart, b.verkaufentwurf_anzahl
    , b.verkaufvertrag_aktenzeichen, b.verkaufvertrag_vertragsart, b.verkaufvertrag_anzahl
    , b.liste_eigentum_kategorie, b.liste_eigentum_organisation, b.liste_eigentum_kuerzel
    , b.liste_besitz_kategorie, b.liste_besitz_organisation, b.liste_besitz_kuerzel
    , b.liste_pacht_aktenzeichen, b.liste_pacht_vertragsart
    , b.liste_pacht_lawi_vertragsart, b.liste_pacht_jagd_vertragsart, b.liste_pacht_frei_vertragsart, b.liste_pacht_sonst_vertragsart
    , b.liste_nutzung, b.liste_nutzart, b.liste_nutzart_nne
    , b.liste_kaufentwurf_aktenzeichen, b.liste_kaufentwurf_vertragsart, b.liste_kaufentwurf_status
    , b.liste_kaufvertrag_aktenzeichen, b.liste_kaufvertrag_vertragsart
    , b.liste_verkaufentwurf_aktenzeichen, b.liste_verkaufentwurf_vertragsart, b.liste_verkaufentwurf_status
    , b.liste_verkaufvertrag_aktenzeichen, b.liste_verkaufvertrag_vertragsart
    , 'ohne', NULL
from v_joinp_all as b
where fk_td_flurstueck__lfdnr not in (
    select pk from st_liegeo
)
;


-- Metadaten aktualisieren
select updateLayerStatistics('st_liegeo');

COMMIT;
