# sys
from os import path
import sqlite3

# Qt
from PyQt5.QtWidgets import QFileDialog, QMessageBox

# QGIS
from qgis.utils import iface
from qgis.core import QgsProject, Qgis
# from qgis.gui import Qgis

class SelectFile():

    # LieGeo-Db
    # dir_proj = QgsProject.instance().readPath("./")
    # dir_proj_data = dir_proj + '/data'
    # db_liegeo = path.normpath(dir_proj_data + '/liegeo.sqlite')
    # !!! db_liegeo kann als Klassenvariable nicht zuverlässig in
    # !!! Klassenmethode aufgerufen werden
    # !!! ergo: Instanzvariable verwenden

    # Initialisierung der Klasse
    # Instanzvariablen festlegen
    # durch 'self' können diese aus der gesamten Klasse aufgerufen werden
    def __init__(self, name_db, switch=False):

        # LieGeo-Db
        dir_proj = QgsProject.instance().readPath("./")
        # dir_proj = QgsProject.instance().absolutePath()
        dir_proj_data = dir_proj + '/data'  # debugging
        self.db_liegeo = path.normpath(dir_proj_data + '/liegeo.sqlite')
        # Debugging
        # db_liegeo = 'C:/LieMaS_Geo_dev/liegeo/liegeo/data/liegeo.sqlite'

        self.name_db = name_db
        self.switch = switch
        self.params = {
            "db": self.name_db
        }
        # Variablen brauchen an dieser Stelle nicht definiert werden
        # fördert jedoch Lesbarkeit und Verständnis über Klasse
        self.path_db = ''
        self.path_selected_file = ''
        self.file_type = ''

        # Übergabe an Klassenmethode
        # return self.connDb()
        self.connDb()  # Aufruf der Methode ohne Rückgabe

        return None  # Konstruktor __init__ sollte immer None zurückgeben

    def connDb(self):
        # Pfad in LieGeo-Db finden
        with sqlite3.connect(self.db_liegeo) as conn:
            sql = """
                select datei from t_sys_pfad
                where name = :db;
            """

            cur = conn.execute(sql, self.params)
            path_db = str(cur.fetchone()[0])

        self.path_db = path.normpath(path_db)

        # Datei-Endung
        self.file_type = path.splitext(self.path_db)[1]

        # Weiche:
        # Aufruf Klassenmethode
        if self.switch == True:
            self.openFileDialog()
        # Ausstieg mit Rückgabe des Db-Pfades
        elif self.switch == False:
            return self.path_db  # Rückgabe path_db

    def openFileDialog(self):
        dialog = QFileDialog()
        # dialog.setFileMode(QFileDialog.AnyFile)

        # Optionen Dialogfenster
        dialog.setOption(QFileDialog.DontUseNativeDialog, True)
        dialog.resize(800, 500)
        if self.name_db == 'Logo':
            dialog.setWindowTitle(f"Auswahl: {self.name_db}")
        else:
            dialog.setWindowTitle(f"Auswahl: {self.name_db} Datenbank")


        # Unterscheidung Datei-Typ
        if self.file_type in ('.accdb', '.mdb'):
            dialog.setNameFilter("ACCDB (*.accdb);; MDB (*mdb)")
        elif self.file_type == '.sqlite':
            dialog.setNameFilter("SQLite3 (*.sqlite)")
        else:
            dialog.setNameFilters(["Bilder (*.png *.jpg *.jpeg *.bmp *.gif *.svg)", "Alle Dateien (*)"])
            # dialog.setMimeTypeFilters(["image/png", "image/jpeg", "image/bmp", "image/gif", "image/svg+xml"])
            # dialog.setViewMode(dialog.Detail)

        # Dateiauswahl
        dialog.selectFile(self.path_db)

        # Dialogaufruf
        if dialog.exec_():
            self.path_selected_file = dialog.selectedFiles()[0]
            # print(f"Datei ausgewählt: {self.path_selected_file}")  # Debug-Ausgabe

            # check: existiert Datei
            if path.exists(self.path_selected_file):

                # Übergabe an Klassenmethode
                self.updateDb()

            else:
                msgBox = QMessageBox()
                msgBox.setIcon(msgBox.Warning)
                msgBox.setWindowTitle('Datei nicht gefunden')
                msgBox.setText(
                    f'Die Datei\n{self.path_selected_file}'
                    '\nwurde nicht gefunden.'
                    '\n\nÜberprüfen Sie Ihre Angaben und '
                    'wiederholen den Vorgang.'
                )
                msgBox.setStandardButtons(msgBox.Ok)
                msgBox.exec_()

                # Dateiauswahl-Dialog erneut aufrufen
                self.openFileDialog()

        else:
            # print("Abbruch durch den Benutzer.")  # Debug-Ausgabe
            # QGIS
            iface.messageBar().pushMessage(
                title= f'Auswahl {self.name_db}:',
                text= 'Abbruch durch den Benutzer.',
                level = Qgis.Warning,
                duration = 3
            )

        return None

    def updateDb(self):
        if self.path_db != self.path_selected_file:
            # neues Element in self.params einfügen
            self.params["path"] = self.path_selected_file
            # oder
            # self.params.update({"path": self.path_selected_file})

            # neuen Db-Dateipfad festschreiben
            with sqlite3.connect(self.db_liegeo) as conn:
                sql = """
                    update t_sys_pfad
                    set datei = :path
                    where name = :db;
                """

                _ = conn.execute(sql, self.params)
        else:
            pass

        return None

# # Bespiel:
# # Instanzieren neuer Klassenobjekte
# select_liemas = SelectFile('LieMaS', True)
# select_alkis_container = SelectFile('ALKIS-Container', True)
# # Attributzugriff
# output = SelectFile('LieMaS').path_db  # Default = False
# print(output)
