#!/usr/bin/env python3
# encoding: utf-8
"""

#-----------------------------------------------------------

Created on Wed Jul 20 12:31:51 2022

@author: Bernd Marcus
"""

# %% [1] module laden
# sys
import datetime as dt
from os import path
from sys import platform
import pandas as pd
import sqlite3
import subprocess

# QGIS
from qgis.core import QgsProject
from qgis.utils import iface

# Qt
from PyQt5 import QtWidgets


class MDBImport:

    def ACCimp(self):

        ###########
        # Variablen
        ###########

        # Zeitmessung
        timer_start = dt.datetime.now()
        # QGIS-Instanz
        qinst = QgsProject.instance()

# %% [1]
        # normpath
        # !!! automatische Steuerung der Syntax für Pfadangaben
        npth = path.normpath

        ####################################################################
        # Änderung Claas Plugin-Verzeichnis umd von dort auf die mdb-Tools zuzugreifen
        ###################################################################

        plugin_dir = npth(path.dirname(__file__))
        # !!! Debug
        #plugin_dir = r'C:\Users\BerndMarcus\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins\LieMas'
        #####################################################

        #####################################
        # Änderung von Claas
        # encoding für die Plattform wählen
        if platform == "linux":
            nc = 'utf-8'
        elif platform == "win32":
            nc = 'mbcs'
        #########################################

        '''-----------------------------
        # Verzeichnispfade: POSIX-Format
        -----------------------------'''

# %% [0]
        # Basisordner
        DIR_BASE = qinst.absolutePath()

# %% [2]
        # !!! Debug
        # DIR_BASE = r'C:\LieMaS_Geo_dev\LieGeo\liegeo'

        # Unterordner
        # DIR_ASSETS = (DIR_BASE + r'/assets')
        DIR_DATA = (DIR_BASE + r'/data')

        # mdb-tools (müssen mitgeliefert werden)
        # MDBTOOLS = (DIR_ASSETS + r'/mdbtools')

        ####################################################################
        # Änderung Claas
        # MDB-Tools im Pluginverzeichnis, werden mit der Installation des
        # Plugins bereitgestellt
        ###################################################################
        # MDBTOOLS = (DIR_DATA + r'/mdbtools')
        MDBTOOLS = (plugin_dir + r'/mdbtools')

        '''-----------------------
        # Datenpfade: Systemformat
        -----------------------'''
        # LieGeo-Datenbank

        DB_NAME = 'liegeo.sqlite'
        LIEMAS_SQL = npth(DIR_DATA + '/' + DB_NAME)

        # LieMaS-Datenbank
        # Pfadangabe in "t_sys_pfad"
        # SQL-Anweisung
        ACC_sql = (
            '''
            select datei from "t_sys_pfad"
            where name = 'LieMaS'
            '''
        )
        #######################################################################
        # Neu von Claas
        ''' ich habe ein paar Sachen getestet. Mein Vorschlag zur Auswahl der
            LieMas-Access-datenbank wäre, das Ganze über einen Auswahldialog
            umzusetzen. Sie die aktive Zeile 130.
        '''
        #######################################################################
        # haus = p.Path.home())
        # accd_ziel = npth(DIR_DATA + '/LieData_70_NABU-StiftungNNE.accdb')

        # Alternatuv den Pfad durch einen Filedialog festlegen
        # accd_ziel = npth(QtWidgets.QFileDialog.getOpenFileName(
        #     filter = "ACCDB (*.accdb)" ,directory = DIR_DATA)[0])

        with sqlite3.connect(LIEMAS_SQL) as conn:
            cur = conn.cursor()
            res = cur.execute(ACC_sql)
            LIEMAS_ACC = res.fetchone()

        if LIEMAS_ACC is not None:
            LIEMAS_ACC = LIEMAS_ACC[0]

        if LIEMAS_ACC is None or not path.exists(LIEMAS_ACC):
            LIEMAS_ACC = npth(QtWidgets.QFileDialog.getOpenFileName(
                filter="ACCDB (*.accdb)", directory=DIR_DATA)[0]
            )
            sqlins = ''' delete from "t_sys_pfad" where name = 'LieMaS';
                        insert into "t_sys_pfad"
                        (name,datei,scope_)
                        values(\'LieMaS\',\'''' + LIEMAS_ACC + '''\',1);
                    '''
            conn = sqlite3.connect(LIEMAS_SQL)
            cur = conn.cursor()
            cur.executescript(sqlins)
            conn.commit()
            cur.close()
            conn.close()
        else:
            LIEMAS_ACC = LIEMAS_ACC

        # !!! Pandas: Serie.to_string() stellt dem Attr. ein Leerzeichen voran
        # !!! und führt zu falscher Pfadangabe
        # !!! ergo: Element über Index auslesen
        '''
        ACC_serie = sql_read(LIEMAS_SQL, ACC_sql, "datei")
        LIEMAS_ACC = ACC_serie[0]
        '''
        # Mit SQLIte3
        '''
        with sqlite3.connect(LIEMAS_SQL) as conn:
            cur = conn.cursor()
            res = cur.execute(ACC_sql)
            LIEMAS_ACC = res.fetchone()[0]
        '''

        # Einfacher:
        # LIEMAS_ACC = npth(QtWidgets.QFileDialog.getOpenFileName(
        #    filter = "ACCDB (*.accdb)" ,directory = DIR_DATA)[0]
        #    )
        #######################################################################
        # ----------------------------------------------------

        #######################################################################
        # Änderung Claas
        # damit das Ganze auch bei meinen test unter Linux läuft
        # Den Pfad zu den MDB-Tools je nach betriebssystem wählen
        # Aufruf der mdb-Tools
        if platform == "linux":
            # MDBTABLES = '/bin/mdb-tables'
            MDBEXPORT = '/bin/mdb-export'
            MDBSCHEMA = '/bin/mdb-schema'
        elif platform == "win32":
            # mdb-tools Module
            # MDBTABLES = npth(MDBTOOLS + '/mdb-tables.exe')
            MDBEXPORT = npth(MDBTOOLS + '/mdb-export.exe')
            MDBSCHEMA = npth(MDBTOOLS + '/mdb-schema.exe')

        # Error Log
        ERR = npth(DIR_DATA + r'/error_sql_statements.txt')
        ##############################################################
        # Änderung Claas
        # Noch ein Protokoll, welche Tabellen erfolgreich exportiert werden,
        ExporBericht = npth(DIR_DATA + r'/export_bericht.txt')
        # ERR = npth(DIR_ASSETS + r'/error_sql_statements.txt')

        '''-----------------------
        # Dateipfade: POSIX-Format
        -----------------------'''

        '''------------------------------------------------------
        # Aufstellung zu importierender Tabellen nach QGIS-Themen
        ------------------------------------------------------'''

        # Tabellenliste
        # LieGeo
        imp_tbl = (
            '''
            select tbl_name
            from t_sys_import_tbl
            where import = true
            ;
            '''
        )

        #########################################
        # Von Claas geändert zu sqlite3
        # Mit pd lief es irgendwie nicht richtig
        ######################################################
        with sqlite3.connect(LIEMAS_SQL) as conn:
            df_tbl = pd.read_sql_query(imp_tbl, conn)  # ,index_col="tbl_name")
            s_tbl = df_tbl['tbl_name']
            tbl_list = s_tbl.to_list()

        # with sqlite3.connect(LIEMAS_SQL) as conn:
        #     cur = conn.cursor()
        #     res = cur.execute(imp_tbl)
        #     tbl_list = res.fetchall()

        # # Ergebnisse der Abfragen in eine Liste schreiben
        # # Mit Korrekturen von störenden Zeichen
        # anz = len(tbl_list)
        # zae = 0
        # writelist  = []
        # while zae < anz:
        #     erg = str(tbl_list[zae]).replace('\'','')
        #     erg = erg.replace(', ',';')
        #     erg = erg.replace('(','')
        #     erg = erg.replace(')','')
        #     erg = erg.replace(',','')
        #     writelist.append(erg)
        #     zae = zae + 1

        # tbl_list = writelist
        ######################################################

# %% [3]
        '''---------
        # Funktionen
        ---------'''
        # Tabellen-Schemata mit mdb-tools holen
        def get_accdb_schema(mdb_schema):
            subproc_schema = subprocess.run(
                mdb_schema,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE,
                # Zeichensatz
                encoding=nc,
                check=True,
                text=True
            )
            subproc_ddl = subproc_schema.stdout
            return subproc_ddl.split('\n')

        # Lesen von Db-Inhalten als pandas.Serie
        # !!!def sql_read(database, stmt): # !!!, attr):
        # def sql_read(conn, stmt):
        #     # Verbindung zur Datenbank
        #     # !!! with sqlite3.connect(database) as conn:
        #     # SQL-Statements als DataFrame
        #     # !!! sql = pd.read_sql_query(stmt, database, index_col="statement")
        #     sql = pd.read_sql_query(stmt, conn, index_col="statement")
        #     # Serie des Eingangattributes
        #     return sql.index # !!! ['statement']

        # Ausführen von SQL-Anweisungen,
        #   die in Db vorgehalten werden
        def sql_exec(database, stmt):
            # Verbindung zur Datenbank
            with sqlite3.connect(database) as conn:
                # Lesen der Db-Inhalte
                sql = pd.read_sql_query(
                    # Rückgabe Stmts in DataFrame-Index
                    stmt, conn, index_col="statement"
                    )

                # Ausführen der SQL-Anweisungen
                for stmt in sql.index:
                    _ = conn.execute(stmt)

            conn.close()

        # Schreiben von Db-Inhalten als pandas.Serie
        def sql_write(arr, database, tbl, attr):
            with sqlite3.connect(database) as conn:
                s = pd.Series(arr, name=attr)
                # Tabelle der zu importierenden Daten
                s.to_sql(tbl, conn, if_exists='replace')

            conn.close()

# %% [0]
        '''----------
        # Anweisungen
        ----------'''

        # Zeitmessung: Export der Tabellen
        # time_1 = dt.datetime.now()

        # sqlite: Löschen aller LieMaS Tabellen
        # Tabelle existiert nicht
        drp_tbl = '''
            select statement from "init_drp_tbl";
            '''
        try:
            sql_exec(LIEMAS_SQL, drp_tbl)  # !!!, "statement")

        except Exception as e:
            print(str(e))

        # 01 DDL's der Tabellen mit mdb-schema aus accdb holen
        # sqlite-Dialekt
        # subprocess string
        schema_sl = [
            MDBSCHEMA, '--drop-table', '--no-indexes',
            '--no-relations', LIEMAS_ACC, 'sqlite'
            ]

        # Tabellenschema über subprocess holen
        ddl_sl = get_accdb_schema(schema_sl)

        # in SQLite festschreiben
        try:
            sql_write(ddl_sl, LIEMAS_SQL, "init_schema_sqlite", "statement")

        except Exception as e:
            print(str(e))

        # postgres-Dialekt
        schema_pg = [MDBSCHEMA, LIEMAS_ACC, 'postgres']

        # Tabellenschema über subprocess holen
        ddl_pg = get_accdb_schema(schema_pg)

        # in SQLite festschreiben
        try:
            sql_write(ddl_pg, LIEMAS_SQL, "init_schema_postgres", "statement")

        except Exception as e:
            print(str(e))

        # 02 Initialisierung SQLite: Tabellen aus Aufstellung erzeugen
        # Tabelle anlegen: "init_tbl_import"
        # sql_write(tbl_list, LIEMAS_SQL, "init_tbl_import", "tbl_name")

        '''
        Hilfstabellen zur Bereitstellungen der Tabellen-Schemata
        sind als Views in der SQLite-Db angelegt.
        Nach Aktualisierung von "init_tbl_import" stehen die SQL-Anweisungen
        zur Erzeugung der Tabellen-Schemata im View
        "init_acc2sql_create_statements" zur Verfügung.
        '''

        # 03 Erstellen: Tabellen-Schemata
        sql = '''
            select statement from "init_acc2sql_create_statements";
            '''
        sql_exec(LIEMAS_SQL, sql)  # !!!, "statement")

        '''
            !!! SQLite Aufruf mit subprocess.run() reagiert sehr empfindlich,
                was die Syntax anbelangt.
                Gliederung der ARGS-Liste für subprocess.run()
                sowie den Wechsel des Verzeichnispfad-Trennzeichens
                unter WINDWOS beachten!!!

        subprocess.run(["sqlite3", LIEMAS_SQL, ".read " + SQL_SCHEMA])
        Out[success]: CompletedProcess(args=[
            'sqlite3',
            'C:\\liemas7\\dev\\liemas6.4_dev_linux\\liemas7_data3.sqlite',
            '.read C:/liemas7/dev/liemas6.4_dev_linux/accdb2sqlite/
                liemas_schema.sql'
            ], returncode=0)

        subprocess.run(["sqlite3", LIEMAS_SQL, ".read", SQL_SCHEMA])
        Out[error]: CompletedProcess(args=[
            'sqlite3',
            'C:\\liemas7\\dev\\liemas6.4_dev_linux\\liemas7_data3.sqlite',
            '.read', 'C:/liemas7/dev/liemas6.4_dev_linux/accdb2sqlite/
                liemas_schema.sql'
            ], returncode=1)

        subprocess.run(['sqlite3',
            'C:\\liemas7\\dev\\liemas6.4_dev_linux\\liemas7_data3.sqlite',
            '.read C:\\liemas7\\dev\\liemas6.4_dev_linux\\accdb2sqlite\\
                liemas_schema.sql'
            ])
        Out[error]: CompletedProcess(args=[
            'sqlite3',
            'C:\\liemas7\\dev\\liemas6.4_dev_linux\\liemas7_data3.sqlite',
            '.read C:\\liemas7\\dev\\liemas6.4_dev_linux\\accdb2sqlite\\
                liemas_schema.sql'
            ], returncode=1)
        '''

        # 04 Daten nach SQLite überführen
        '''
        * SQL generieren und in Variable schreiben
        '''
        with sqlite3.connect(LIEMAS_SQL) as conn:

            fk_off = """
                PRAGMA foreign_keys = off;
            """
            conn.execute(fk_off)

            # Zeitmessung: Export einzelner Tabellen
            # time_1b = dt.datetime.now()
            anzahl = 0
            anzahl_fehlschlag = 0
            tab_list = []
            for table in tbl_list:
                # Zeilenumbruch von stdout der Tabellenliste ausnehmen
                # (bei allen Tabellen)
                if table != '\n':

                    try:
                        # Zeitmessung: Export einzelner Tabellen
                        # time_1b = dt.datetime.now()
                        # print('Export von Tabelle: ' + table)

                        with open(ERR, "a") as error:
                            result = subprocess.run(
                                [
                                    MDBEXPORT,
                                    '--insert=sqlite',
                                    '--quote=\'',
                                    '--null=NULL',
                                    '--bin=hex',
                                    LIEMAS_ACC,
                                    table
                                ],
                                # Zeichensatz nach Betriebssystem wählen
                                # jetzt über die Variable nc
                                encoding=nc,
                                check=True,
                                text=True,
                                stdout=subprocess.PIPE,
                                stderr=error
                            )

                        # print (result.stdout)

                        # Schreiben in Exportbericht:

                        # Änderung Claas
                        # Protokoll der imprtierten Tabellen
                        tab_list.append(table)
                        # doing_list.append(result.stdout)

                        conn.executescript(result.stdout)

                        # time_2b = dt.datetime.now()
                        # print (time_2b - time_1b)
                        anzahl = anzahl + 1

                    except Exception as e:
                        # Fortfahren, wenn Tabellen nicht existieren
                        # pass
                        anzahl_fehlschlag = anzahl + 1
                        print(
                            'Hier ist etwas Unerwartetes passiert!\n' + str(e)
                            )

                        # Änderung Claas
                        # Meldung als QGIS-PushNachricht
                        iface.messageBar().pushInfo(
                            'Info',
                            'hier ist etwas Unerwartetes passiert!\n' + str(e)
                            )

            fk_on = """
                PRAGMA foreign_keys = on;
                """

            conn.execute(fk_on)
            conn.execute('vacuum;')
            conn.execute('pragma optimize;')

        conn.close()

            # print ('Tabellenschemata, Referenzen,' \
            # + ' Contraints und Indizes erfolgreich exportiert.\n ' \
            # + 'Ausführungsdauer: ' + str(time_2b - time_1b))

        # Ergänzung Claas
        # Liste der importierten Tabellen als Protokoll
        zae = 0
        writelist = []
        # print(tab_list)
        while zae < anzahl:
            erg = str(zae + 1) + ' ' + str(tab_list[zae]) + ("\n")
            # erg_anzahl = len(erg)
            writelist.append(erg)
            zae = zae + 1

        Bericht = open(ExporBericht, 'w')
        Bericht.writelines(writelist)
        Bericht.close()

        # zae = 0
        # writelist = []
        # #print(tab_list)
        # while zae < anzahl:
        #     erg = str(zae + 1) + ' ' + str(doing_list[zae])+ ("\n")
        #     #erg_anzahl = len(erg)
        #     writelist.append(erg)
        #     zae = zae + 1

        # DoingBericht  = npth(DIR_DATA + r'/Doing_bericht.txt')
        # Bericht = open(DoingBericht,'w')
        # Bericht.writelines(writelist)
        # Bericht.close()

        #time_2 = dt.datetime.now()
        timer_end = dt.datetime.now()

        # # Änderung Claas
        # # Rückgabe des Erfolgs als Push-nachricht
        # msg = 'Import für ' + str(anzahl) + ' Tabellen erfolgreich und für ' \
        #     + str(anzahl_fehlschlag) \
        #     + ' tabellen gescheitert: Gesamte Verarbeitungsdauer: ' \
        #     + str(timer_end - timer_start)
        #     # + str(time_2 - time_1)
        self.process_time = timer_end - timer_start
        return self.process_time
