# encoding: utf-8
#-----------------------------------------------------------
# Autor
# Claas Leiner GKG
#
#-----------------------------------------------------------
# Licensed under the terms of GNU GPL 2
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#---------------------------------------------------------------------
# Themen wählen und Stil com ergebnis

# sys
import os
from sys import platform
from datetime import datetime
import sqlite3 as sq
import subprocess

# QGIS
from qgis.core import QgsApplication, QgsProject, QgsVectorLayer, QgsVectorFileWriter, QgsCoordinateTransform, QgsCoordinateReferenceSystem, Qgis
from qgis.utils import iface
# from qgis.gui import Qgis
from qgis.gui import QgsMessageBar
from qgis.PyQt.QtGui import QAction, QIcon
import processing

# Qt
from PyQt5.QtCore import QTimer

# Plugin
from .mdbimport import MDBImport
from .alkisimport import AlkisImport
from .selectfile import SelectFile
#from .schreib import schreib

# Spyder-Style
# from mdbimport import MDBImport as mi
# from alkisimport import AlkisImport
# from schreib import schreib


class liemas:

    def __init__(self, iface):
        self.iface = iface
        self.canvas = self.iface.mapCanvas()
        self.propfad = os.path.dirname(QgsApplication.qgisSettingsDirPath())
        self.projektpfad = os.path.normcase(QgsProject.instance().homePath())
        self.plugin_dir = os.path.dirname(__file__)
        self.provider = None

    #def initProcessing(self):
        #"""Init Processing provider for QGIS >= 3.8."""
        #self.provider = GKGProvider()
        #QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):  # Toolbar und Schaltflächen einrichten
        #. Add toolbar
        self.toolBar = self.iface.addToolBar("LieGeo")
        #self.initProcessing()

        # Erweiterung im Plugin-Menü verfügbar machen
        # self.menu = self.iface.addPluginToMenu('LieGeo', self.action)

        # Liemas-Suche Schaltfläche
        # self.lie_such =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"Such.png"))),"LieMasSuche", self.iface.mainWindow())

        # self.lie_such = QAction(
        #     QIcon(os.path.normcase(os.path.join(
        #         self.plugin_dir + "/img" ,"search.png"
        #         ))
        #     ),"LieGeo-Suche", self.iface.mainWindow()
        # )
        # self.lie_such.setEnabled(True)
        # self.lie_such.setCheckable(True)
        # self.lie_such.triggered.connect(self.liesuch)
        # self.lie_such_button = self.toolBar.addAction(self.lie_such)

        # # leerer Button
        # self.mas_leer0 =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"leer.svg")))," ", self.iface.mainWindow())
        # self.mas_leer0_button = self.toolBar.addAction(self.mas_leer0)

        # # Aktion Kartenthema Eigentum
        # self.te_eigentum =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"nabu.png"))),"Thema Eigentum nabu", self.iface.mainWindow())
        # self.te_eigentum.triggered.connect(self.te_ege)
        # self.te_eigentum_button = self.toolBar.addAction(self.te_eigentum)

        # # Aktion Kartenthema Eigentumsituation
        # self.te_eigen =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"export.svg"))),"Thema Eigentumssituation", self.iface.mainWindow())
        # self.te_eigen.triggered.connect(self.te_eig)
        # self.te_eigen_button = self.toolBar.addAction(self.te_eigen)

        # # Aktion Kartenthema Leitbild
        # self.te_leitbild =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"L.svg"))),"Thema Leitbild", self.iface.mainWindow())
        # self.te_leitbild.triggered.connect(self.te_leitb)
        # self.te_leitbild_button = self.toolBar.addAction(self.te_leitbild)

        # # Aktion Kartenthema Nutzung
        # self.te_nutzung =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"nweg.svg"))),"Thema Nutzung", self.iface.mainWindow())
        # self.te_nutzung.triggered.connect(self.te_nutz)
        # self.te_nutzung_button = self.toolBar.addAction(self.te_nutzung)

        # # Aktion Kartenthema Pacht
        # self.te_pacht =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"pacht.svg"))),"Thema Pacht", self.iface.mainWindow())
        # self.te_pacht.triggered.connect(self.te_pa)
        # self.te_pacht_button = self.toolBar.addAction(self.te_pacht)

        # # leerer Button
        # self.mas_leer0 =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"leer.svg")))," ", self.iface.mainWindow())
        # self.mas_leer0_button = self.toolBar.addAction(self.mas_leer0)

        # Schnelldruck
        # self.druck_layout =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"druck.png"))),"Layout als PDF drucken", self.iface.mainWindow())
        self.druck_layout = QAction(
            QIcon(os.path.normcase(os.path.join(
                self.plugin_dir + "/img", "map_bw_pdf.png"
                ))
            ), "Kartenansicht als PDF speichern", self.iface.mainWindow()
        )
        self.druck_layout.triggered.connect(self.druck_lay)
        self.druck_layout_button = self.toolBar.addAction(self.druck_layout)

        # LieGeo aktualisieren
        # self.accdb_importieren =  QAction(QIcon(os.path.normcase(os.path.join(self.plugin_dir + "/pic" ,"xweg.svg"))),"Liemas-Datenbank importieren", self.iface.mainWindow())
        self.accdb_importieren = QAction(
            QIcon(os.path.normcase(os.path.join(
                self.plugin_dir + "/img" ,"download.png"
                ))
            ),"LieGeo aktualisieren", self.iface.mainWindow()
        )
        self.accdb_importieren.triggered.connect(self.pushMsg)
        self.accdb_importieren_button = self.toolBar.addAction(self.accdb_importieren)

        # LieGeo aktualisieren
        self.select_paths = QAction(
            QIcon(os.path.normcase(os.path.join(
                self.plugin_dir + "/img" ,"setting_red.png"
                ))
            ),"Dateipfade anpassen", self.iface.mainWindow()
        )
        # !!!Trigger anpassen!!!
        self.select_paths.triggered.connect(self.selectPaths)
        self.select_paths_button = self.toolBar.addAction(self.select_paths)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
        # del self.lie_such_button

        #self.iface.removeToolBarIcon(self.fo_ein)
        if self.toolBar is not None:
            del self.toolBar

    def selectPaths(self):
        select_liemas = SelectFile('LieMaS', True)
        select_alkis_container = SelectFile('ALKIS-Container', True)
        select_logo = SelectFile('Logo', True)

    def pushMsg(self):
        iface.messageBar().pushMessage(
            title= 'Synchronisation:',
            text= 'Liegeo wird mit LieMaS-Daten abgeglichen',
            level = Qgis.Info,
            duration = 1  # sek
        )
        # oder mit Default-Timeout
        # iface.messageBar().pushInfo('Synchronisation:', 'Liegeo wird mit LieMaS-Daten abgeglichen')
        # QTimer.singleShot(10, self.accdbImport)  # msek
        QTimer.singleShot(1, self.accdbImport)  # msek

    def accdbImport(self):
        # MDB-Import aus LieMaS
        mdb_import_inst = MDBImport()  # Erstelle Instanz von MDBImport
        self.accdb_import = mdb_import_inst.ACCimp()
        self.time_accdb_import = mdb_import_inst.process_time  # Zugriff auf das Instanzattribut

        # !!!Hinweis zum Einzeiler von Claas:
        # self.accdb_import = MDBImport.ACCimp(self)
        # !!!self bindet die aktuelle Instanz der Klasse Liemas als Instanz von MDBImport ein
        # !!!Dies ist nicht korrekt, da Liemas und MDBImport unterschiedliche Klassen sind.
        # !!!Funktioniert zwar, ist aber fehleranfällig. GRUNDSÄTZLICH sollte daher erst die Instanz einer Klasse erstellt werden.

        # iface.messageBar().pushSuccess('Aktualisierung erfolgreich', str(self.accdb_import))
        self.alkisImpMsg()

    def alkisImpMsg(self):
        iface.messageBar().pushMessage(
            title= 'ALKIS-Abgleich:',
            text= 'Liegeo wird mit Flurstücksgeometrien verknüpft',
            level = Qgis.Info,
            duration = 1  # sek
        )
        # oder
        # iface.messageBar().pushInfo('ALKIS-Abgleich:', 'Liegeo wird mit Flurstücksgeometrien verknüpft')

        QTimer.singleShot(1, self.alkisImport)  # sek

    def alkisImport(self):
        # ALKIS-Import
        alkis_import_inst = AlkisImport()
        self.alkis_import = alkis_import_inst.import_from_alkis_container()
        self.time_alkis_import = alkis_import_inst.process_time

        iface.messageBar().clearWidgets()
        iface.messageBar().pushSuccess('Ergebnis:', str(self.time_accdb_import + self.time_alkis_import))


#
#     def te_ege(self):  # Thema Eigentum
#         project = QgsProject.instance()
#         vlayer = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#         iface.setActiveLayer(vlayer)
#         root = project.layerTreeRoot()
#         model = iface.layerTreeView().layerTreeModel()
#         mtc = QgsProject.instance().mapThemeCollection()
#         name = 'sv_alkis_EigentumN'
#         mtc.applyTheme(name, root, model)
#
#     def te_eig(self):  # Thema Eigentumssitaution
#         project = QgsProject.instance()
#         vlayer = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#         iface.setActiveLayer(vlayer)
#         root = project.layerTreeRoot()
#         model = iface.layerTreeView().layerTreeModel()
#         mtc = QgsProject.instance().mapThemeCollection()
#         name = 'sv_alkis_Eigentumssituation'
#         mtc.applyTheme(name, root, model)
#
#
#
#     def te_leitb(self):  # Thema leitbild
#         project = QgsProject.instance()
#         vlayer = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#         iface.setActiveLayer(vlayer)
#         root = project.layerTreeRoot()
#         model = iface.layerTreeView().layerTreeModel()
#         mtc = QgsProject.instance().mapThemeCollection()
#         name = 'sv_alkis_Leitbild'
#         mtc.applyTheme(name, root, model)
#
#     def te_nutz(self):  # Thema Nutzung
#         project = QgsProject.instance()
#         vlayer = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#         iface.setActiveLayer(vlayer)
#         root = project.layerTreeRoot()
#         model = iface.layerTreeView().layerTreeModel()
#         mtc = QgsProject.instance().mapThemeCollection()
#         name = 'sv_alkis_Nutzung'
#         mtc.applyTheme(name, root, model)
#
#     def te_pa(self):  # Thema Nutzung
#         project = QgsProject.instance()
#         vlayer = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#         iface.setActiveLayer(vlayer)
#         root = project.layerTreeRoot()
#         model = iface.layerTreeView().layerTreeModel()
#         mtc = QgsProject.instance().mapThemeCollection()
#         name = 'sv_alkis_Pacht'
#         mtc.applyTheme(name, root, model)
#
#     # Die gesamte Suchfunktion
#     def liesuch(self, checked):
#
#         project = QgsProject.instance()                 # Das aktuelle QGIS-Projekt
#         vtab = project.mapLayersByName("tab_suche")[0]  # Die Tabelle zum Eintragen der Suchanfrage nach Layername
#         root = project.layerTreeRoot()                  # Das Projekt-Inhalstverzeichnis, gebraucht beim aktiv setzen von layern etc.
#
#         iface.setActiveLayer(vtab)              # vtab also die Tabelle mit den Sucheintrögen wird aktiv gesetzt
#         root.findLayer(vtab.id()).setItemVisibilityCheckedParentRecursive(True)  # Es wird dafür gesorgt, das das layer-Inhaltsverzeichnis ausgeklaptt wird
#
#         # Datenbank anmelden und alten Inhalt löschen
#         pfad = vtab.dataProvider().uri().database()
#         #pfad= vtab.dataProvider().dataSourceUri()              # Pfad zur SQlite-Datenbank, in der die Tablle vtab =  tab_suche gespeichert ist
#         #pfad= pfad.split(' ')[0].replace('dbname=','').replace("'","") # aus der Sourceuri den Pfad extrahieren, der tabellenname wird abgetrennt
#         #pfad= pfad.split('|')[0]# aus der Sourceuri den Pfad extrahieren, der tabellenname wird abgetrennt
#         #pfad= pfad.replace('dbname=','').replace(' table="tab_suche"','').replace("'","")
#         verz,dat = os.path.split(pfad)                          # Verzeichnis und Dateiname werden voneiander getrennt
#         aus_verz = os.path.normcase(verz + '/ausgabe')
#         if not os.path.exists(aus_verz):
#             os.makedirs(aus_verz)
#
#         #vektorwriter definieren
#         #Funktion zum Speichern von Vektorlayern in verschiedenen Formaten
#         # form : Ausgabeform, pad: Verzeichnis in dem gespeichert wird, lay: der zu speichernde Vektorlayer, name: der Dateiname des gespeicherten Layers, sel: True oder False für nur gewählte oder sämtliche.
#         def vekwr(form,pad,lay,name,sel):  # sel 0 True or False für die Verarbeitung nur gewählter Layer
#             layer = lay
#             if form == 'shp':
#                 path = pad + "/" + name + '.shp'
#                 writer = QgsVectorFileWriter.writeAsVectorFormat(layer,path,'utf-8',driverName='ESRI Shapefile', onlySelected=sel,layerOptions= ['SPATIAL_INDEX=YES'])
#             elif form == 'xlsx':
#                 path = pad + "/" + name + '.xlsx'
#                 writer = QgsVectorFileWriter.writeAsVectorFormat(layer,path,'utf-8',driverName='XLSX', onlySelected=sel)
#             elif form == 'gpkg':
#                 path = pad + "/" + name + '.gpkg'
#                 writer = QgsVectorFileWriter.writeAsVectorFormat(layer,path,'utf-8',driverName='GPKG', onlySelected=sel,layerOptions= ['SPATIAL_INDEX=YES'])
#             elif form == 'gpx':
#                 path = pad + "/" + name + '.gpx'
#                 writer = QgsVectorFileWriter.writeAsVectorFormat(layer,path,'utf-8',driverName='GPX', onlySelected=sel,datasourceOptions=["GPX_USE_EXTENSIONS=ON"],layerOptions= ['FORCE_GPX_TRACK=YES'],ct=QgsCoordinateTransform(layer.crs(), QgsCoordinateReferenceSystem(4326), QgsProject.instance()) )
#             return writer
#         #vekwr('gpkg',verz,lay,'ausgabe',True)
#
#
#         if checked:   # Wenn die Schaltfläche gedrückt wird
#             db = sq.connect(pfad)       # Verbindung zur Datenbank abfrageb
#             db_zeiger = db.cursor()                 # Cursor auf die datenbank
#             db_zeiger.execute("delete from tab_suche;")  # Alte Sucheinträge löschen
#             db_zeiger.execute("commit;")                # Aus Befehl schreiben
#             db.commit()
#             db_zeiger.close()
#             db.close()                                  # Datenbank schließeen
#
#             vtab.startEditing()                         # Die Tabelle tab_suche bearbeitbar schalten
#             iface.actionAddFeature().trigger()  # Eingabemaske über "Neues Feature hinzufügen" öffnen
#
#         else:                       # Ein zweites drücken auf die Schaltfläche
#             schreib.schreib(self)   # Deri neue Sucheitrag wird geschrieben
#
#             # Die beiden Layer, in denen später gesucht wird als Variable festlegen
#             #pacht = QgsProject.instance().mapLayersByName("Pacht")[0]
#             #pacht = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#             #eigentum = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#             #gesamt = QgsProject.instance().mapLayersByName("sv_alkis__flst_gema")[0]
#             pacht = QgsProject.instance().mapLayer("sv_alkis__flst_gema__v_joinp_flurstueck_f0813050_7da4_4b64_930f_ed1407faee39")
#             eigentum = QgsProject.instance().mapLayer("sv_alkis__flst_gema__v_joinp_flurstueck_f0813050_7da4_4b64_930f_ed1407faee39")
#             gesamt = QgsProject.instance().mapLayer("sv_alkis__flst_gema__v_joinp_flurstueck_f0813050_7da4_4b64_930f_ed1407faee39")
#             # gesamtid = QgsProject.instance().mapLayer("sv_alkis__flst_gema__v_joinp_flurstueck_f0813050_7da4_4b64_930f_ed1407faee39")
#
#             # jar = datetime.now().strftime('%Y')
#             # mon = datetime.now().strftime('%Y_%m')
#             dat = datetime.now().strftime('%Y_%m_%d')
#             ti = datetime.now().strftime('%H_%M')
#             zeit = str(dat) + '_' + str(ti)
#
#
#             ########################################################
#             # Jetzt werden die Suchanfragen in Variablen geschrieben #
#             #########################################################
#
#             #Funktion für die Abfragen definieren
#             def db_abfr(abfr):
#                 db = sq.connect(pfad)    # Verbindung zur Datenbank abfrageb
#                 dbc = db.cursor()       # Cursor auf die datenbank
#                 dbc.execute(abfr)  # Abfrage durchführen
#                 zeile = dbc.fetchone()       # Zeile holen
#                 if zeile != None:
#                     zeile = zeile[0]                # Nur den textwert aus dem Tupel holen
#                 dbc.close()             # Cursor schließen
#                 db.close()              # datenbank schließen
#
#                 return zeile           # Emittelten textwert zurückgeben
#
#             # id
#             abfr = "select id from tab_suche limit 1;"
#             idi = db_abfr(abfr)
#             if idi == None:
#                 iface.messageBar().pushInfo('Info','Keine Eingabe')
#
#             else:
#
#                 # Bezirk
#                 abfr = "select Bezirk from tab_suche limit 1;"
#                 bezirk = db_abfr(abfr)
#
#                 # Gebiet
#                 abfr =  "select gebiet from tab_suche limit 1;"
#                 gebiet = db_abfr(abfr)
#
#                 # Landkreis
#                 abfr =  "select landkreis from tab_suche limit 1;"
#                 landkreis = db_abfr(abfr)
#
#                 # gemeinde
#                 abfr =  "select gemeinde from tab_suche limit 1;"
#                 gemeinde = db_abfr(abfr)
#
#                 # gemarkung
#                 abfr =  "select gemarkung from tab_suche limit 1;"
#                 gemarkung = db_abfr(abfr)
#
#                 # flur
#                 abfr =  "select flur from tab_suche limit 1;"
#                 flur = db_abfr(abfr)
#
#                 # zaehler
#                 abfr =  "select zaehler from tab_suche limit 1;"
#                 zaehler = db_abfr(abfr)
#
#                 # nenner
#                 abfr =  "select nenner from tab_suche limit 1;"
#                 nenner = db_abfr(abfr)
#
#                 # projekt
#                 abfr =  "select projekt from tab_suche limit 1;"
#                 projekt = db_abfr(abfr)
#
#                 # pacht_vetragsart
#                 abfr =  "select pacht_vetragsart from tab_suche limit 1;"
#                 pacht_vetragsart = db_abfr(abfr)
#
#                 # pacht_bezeichnung
#                 abfr =  "select pacht_bezeichnung from tab_suche limit 1;"
#                 pacht_bezeichnung = db_abfr(abfr)
#
#                 # pacht_aktenzeichen
#                 abfr =  "select pacht_aktenzeichen from tab_suche limit 1;"
#                 pacht_aktenzeichen = db_abfr(abfr)
#
#                 #Prüfen
#                 print(bezirk)
#                 print(gebiet)
#                 print(landkreis)
#                 print(gemeinde)
#                 print(gemarkung)
#                 print(flur)
#                 print(zaehler)
#                 print(nenner)
#                 print(projekt)
#                 print(pacht_vetragsart)
#                 print(pacht_aktenzeichen)
#                 print(pacht_bezeichnung)
#
#
#                 sz = (str(bezirk) , str(gebiet) ,str(landkreis) ,str(gemeinde) ,str(gemarkung) ,str(flur), str(zaehler) ,str(nenner) ,str(projekt))
#                 print(sz)
#                 sz = list(sz)
#                 print(sz)
#
#                 akt_sz = set(sz)
#                 akt_sz.remove('None')
#
#                 sz = set(sz)
#                 print(sz)
#                 #sz = list(sz)[0]
#
#                 print(sz)
#                 print(len(sz))
#
#                 if 'None' in sz and len(sz) == 1:
#                     sz = 0
#                 else:
#                     sz = 1
#
#                 print(sz)
#                 print(akt_sz)
#
#                 erg = gesamt
#                 fertig = 0
#
#
#
#                 #Funktion zur Extraktion der Layer
#                 #abfr = '"bezirk" =' + "'" + abfr + "'" +''
#                 ###################################################################
#                 ##########################################################
#                 def extr(eingabe,abfr):
#                     alg_params = {
#                             'EXPRESSION': abfr ,
#                             'INPUT': eingabe,
#                             'OUTPUT': 'memory:'
#                     }
#                     ausgabe = processing.run('native:extractbyexpression', alg_params)
#                     ausgabe = ausgabe['OUTPUT']
#
#                     return ausgabe
#                 # Funktion extrahier die  Objekte auf die die Abfrage zutriff als Layerobjekt
#                 ########################################################
#                 ########################################################
#
#
#                 if sz == 1:
#
#                     ######################################
#                     #Gesuchtew Flurstücke schrittweise auswählen und extrahieren
#                     ########################################
#
#                     #####################################################
#                     # Schritt 1 Bezirke
#                     #####################################################
#                     fertig = 0
#                     #Bezirk
#                     if bezirk != None:                                 # Abfrage wird nur durchgeführt, wenn der Bezirk ausgewählt worden ist
#                         abfr = '"bezirk" =' + "'" + bezirk + "'" +''   # Die Abfrage für die QGIS-Expression
#                         eigentum.selectByExpression(abfr)               # Im Layer eigentum wird zusätzlich eine Auswahl erstellt
#                         bez_extr = extr(eigentum,abfr)      # Die Voher definierte Funktion extr() wird mit der AbfrAGE au dem Eigentum-Layer durchgeführt und in der Variable bez_extr gespeicher
#                     else:
#                         bez_extr = eigentum                   # Wenn keine Bezirk abgefragt wird, enthält die Variable bet_extr den unveränderten Eigentums-Layer
#
#                     erg = bez_extr                          # Ergebnis der jeweiligen Abfrage wird immer in der Variable erg gespeichert
#                     # Entweder sind Bezirke ausgewählt oder der gesamte Layer wird weiter gereicht
#                     #########################################################
#
#                     ##########################################################
#                     #Schritt 2 Landkreis
#                     ##########################################################
#                     if landkreis != None:          # Abfrage wird nur durchgeführt, wenn der Kreis ausgewählt worden ist
#                         # Wenn das Zwischenergebnis erg nicht dem Ursprungslayer eigentum entspricht, also im vorherigen Schritt eine Auswahl durchgeführt wurde,
#                         if erg != eigentum:    # wird die nächste Extraktion auf dem Ergebnis der vorhergehenden Extraktion durchgeführt  in diesem fall der Bezirk
#
#                             abfr = '"landkreis" =' + "'" + landkreis + "'" +''  # Die Abfrage zur Ermittlung des LKR
#                             # Auf dem Eigentumslayer wird die nächste Auswahl nur auf den vorher gewählten Objekten durchgeführt: Methode: QgsVectorLayer.IntersectSelection
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             # Es folgt der Extraktion der Kreise auf dem vorherigen Ergebnis (Variable erg)
#                             landkreis_extr = extr(erg,abfr)
#
#                         else:   #Wenn das vorherige Ergebnis dem Ausgangslayer eigentum entspricht, wird auf diesen die Extraktion der Kreise vorgenommen
#                             abfr = '"landkreis" =' + "'" + landkreis + "'" +''  # Die Abfrage
#                             landkreis_extr = extr(eigentum,abfr)
#                             eigentum.selectByExpression(abfr)
#
#                     else:
#                         landkreis_extr = erg  # Wenn keine Landkreise abgefragt wird, enthält die Variable landkreis_extr den unveränderten Werte des vorherigen Ergebnisses
#                         fertig = 1      # Weil hier keine neue Extraktion erstellt wurde, bekommt die Va<iable fertig den Wert 1, also die erste Abfrage ist schon ein Ergebnis
#                         print('F1: ' + str(fertig))
#
#                     erg = landkreis_extr # Ergebnis der jeweiligen Abfrage wird immer in der Variable erg gespeichert
#
#                     ######################################################
#                     # Schritt 3 Gebiet
#                     #####################################################
#                     #Gebeit
#                     if gebiet != None:                              # Nur wenn die Gebiete gewählt worden sind
#                         if erg != bez_extr:                         # Wenn das Ergebnis nicht derm Ergebnis vor den landkreisen entspricht, also die landkreise ausgewählt wurden
#                             abfr = '"gebiet" =' + "'" + gebiet + "'" +''
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             geb_extr = extr(erg,abfr)
#
#                         else:       # jetzt die Alternative, wenn die LKR nicht ausgewählt wurden
#                             abfr = '"gebiet" =' + "'" + gebiet + "'" +''
#                             geb_extr = extr(bez_extr,abfr)
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             #QgsProject.instance().addMapLayer(geb_extr)
#                     else:           # Wenn keine Gebiet gewählt worden ist, das vorherige Ergebnis einfach übernehmen und dieses als Fertig kennzeichnen
#                         geb_extr = erg
#                         fertig = 2
#                         print('F2: ' + str(fertig))
#
#                     #eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                     erg = geb_extr
#                     ######################################################
#                     #########################################
#
#                     ######################################################
#                     # Schritt 4 Gemeinde
#                     #####################################################
#                     #Gemeinde
#                     if gemeinde != None:
#                         if erg != landkreis_extr:
#                             abfr = 'replace("gemeinde",\', Stadt\',\'\') =' + "'" + gemeinde + "'" +''
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             gemein_extr = extr(erg,abfr)
#                             #QgsProject.instance().addMapLayer(gemein_extr)
#                         else:
#                             abfr = 'replace("gemeinde",\', Stadt\',\'\') =' + "'" + gemeinde + "'" +''
#                             gemein_extr = extr(landkreis_extr,abfr)
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#
#                         #QgsProject.instance().addMapLayer(gemein_extr)
#                     else:
#                         gemein_extr = erg
#                         fertig = 3
#                         print('F3: ' + str(fertig))
#
#                     #eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                     erg = gemein_extr
#                     ######################################################
#                     #########################################
#
#                     ######################################################
#                     # Schritt 5 Gemarkung
#                     #####################################################
#                     #Gemarkung
#                     if gemarkung != None:
#                         if erg != geb_extr:
#                             abfr = '"gemarkung" =' + "'" + gemarkung + "'" +''
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             gema_extr = extr(erg,abfr)
#                         else:
#                             abfr = '"gemarkung" =' + "'" + gemarkung + "'" +''
#                             gema_extr = extr(geb_extr,abfr)
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#
#                         #QgsProject.instance().addMapLayer(gema_extr)
#                     else:
#                         gema_extr = erg
#                         fertig = 4
#                         print('F4: ' + str(fertig))
#
#                     #eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                     erg = gema_extr
#                     ######################################################
#                     #########################################
#
#                     #####################################################
#                     # Schritt 6 Flur
#                     #####################################################
#                     #Flur
#                     if flur != None:
#                         if erg != gemein_extr:
#                             abfr = 'to_string(to_int("flur")) =' + "'" + str(flur) + "'" +''
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             flur_extr = extr(erg,abfr)
#                         else:
#                             abfr = 'to_string(to_int("flur")) =' + "'" + str(flur) + "'" +''
#                             flur_extr = extr(gemein_extr,abfr)
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#
#                         #QgsProject.instance().addMapLayer(flur_extr)
#                     else:
#                         flur_extr = erg
#                         fertig = 5
#                         print('F5: ' + str(fertig))
#
#                     #eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                     erg = flur_extr
#                     ######################################################
#                     #########################################
#
#                     #####################################################
#                     # Schritt 7 Zaehler
#                     #####################################################
#                     #Zaehler
#                     if zaehler != None:
#                         if erg != gema_extr:
#                             abfr = 'to_string(to_int("zaehler")) =' + "'" + str(zaehler) + "'" +''
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             zaehler_extr = extr(erg,abfr)
#                         else:
#                             abfr = 'to_string(to_int("zaehler")) =' + "'" + str(zaehler) + "'" +''
#                             zaehler_extr = extr(gema_extr,abfr)
#                             eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                             fertig = 7
#                             print('F7: ' + str(fertig))
#
#                         #QgsProject.instance().addMapLayer(zaehler_extr)
#                     else:
#                         zaehler_extr = erg
#                         fertig = 6
#                         print('F6: ' + str(fertig))
#
#                     #eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                     erg = zaehler_extr
#
#
#                     ################################################
#                     # Projekte extrahieren
#                     #############################################
#                     if projekt != None:
#                         abfr = '"projekt" =' + "'" + projekt + "'" +''
#                         eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                         projekt_extr = extr(erg,abfr)
#                         fertig = 8
#                         print('F8: ' + str(fertig))
#                     else:
#                         projekt_extr = erg
#                         print('F ferig: ' + str(fertig))
#
#                     #eigentum.selectByExpression(abfr,QgsVectorLayer.IntersectSelection)
#                     erg = projekt_extr
#                     ######################################
#                     #####################################
#
#                 ######################################################
#                 ###################################################
#                 #Abfrage zur Ermittlung von Pachtflächen - Aktenzeichen, Bezeichnung und Vertragsart können ausgesucht werden
#                 ###########################################################################################
#                 if pacht_vetragsart != None or pacht_bezeichnung != None  or pacht_aktenzeichen != None:  # Nur wenn auch pachtrelevante Inhalte abgefragt wurden
#                     fls_id = []             # Die Liste für die Flurtuecksids wird angelegt
#                     for feature in erg.getFeatures():               # Für jedes Objekt im bisherigen Ergebnis
#                         flid = feature["fk_td_flurstueck__lfdnr"]  # Es werden die laufendes Nummern der Ergebnisflurstücke ermittelt
#                         #print(flid)
#                         fls_id.append(flid)                        # und in eine Liste geschrieben
#
#                     #del(fls_id[0])
#                     #pacht_vertragsart
#                     fls_id = str(tuple(fls_id))                     # über die Umwandlung in Tupel und Text. wird es in eine bessere Form für die QGIS-in-Abfrage gebracht: (w1,w2,...)
#                     # Die folgenden Abfragen werten die laufenden Flurstücksnummern aus um die Flächen im pachtlayer einzugrenzen (in fls_id)
#                     # Um anschließend die Vertragsart oder Anschließend nach Aktenzeichen oder Pachtart zu suchen
#                     if  (pacht_bezeichnung == None)  and  (pacht_aktenzeichen == None) and (pacht_vetragsart != None):
#                         abfr =  '"fk_td_flurstueck__lfdnr"  in ' +  fls_id + ' and "liste_vertragsart" like ' + "'%" + pacht_vetragsart + "%'" +''
#
#                     elif (pacht_bezeichnung != None)  and  (pacht_aktenzeichen != None ) and  (pacht_vetragsart == None):
#                         abfr =  '"fk_td_flurstueck__lfdnr"  in ' +  fls_id + ' and "liste_aktenzeichen" like ' + "'%" + pacht_aktenzeichen + "%'" +''
#
#                     elif  (pacht_bezeichnung != None)  and  (pacht_aktenzeichen != None ) and  (pacht_vetragsart != None):
#                         abfr =  '"fk_td_flurstueck__lfdnr"  in ' +  fls_id + ' and "liste_aktenzeichen" like ' + "'%" + pacht_aktenzeichen + "%'" ' and "liste_vertragsart" like ' + "'%" + pacht_vetragsart + "%'"  +''
#
#
#                     #print(abfr)
#                     # Jetzt wird die Extraktion auf dem pachtlayer mit der Abfrage durchgeführt
#                     extr_pacht = extr(pacht,abfr)
#                     pacht.selectByExpression(abfr)
#
#                     vekwr('gpkg',aus_verz,extr_pacht,'pacht_' + zeit,False)  # Geopackage schreiben
#                     vekwr('xlsx',aus_verz,extr_pacht,'pacht_' + zeit,False)  # excel schreiben
#                     pachtext = os.path.normcase(aus_verz +'/pacht_' + zeit + '.gpkg')   # Pfad zum geopackage in variable schreiben
#
#                     erg2layer = iface.addVectorLayer(pachtext, "SuchergebnisPacht_" + zeit, "ogr")  # Als neuen Vektorlayer definieren
#                     QgsProject.instance().addMapLayer(erg2layer)                                        # Ins Projekt laden
#                 ##################################################################################
#                 #################################################################################
#
#
#                 ##########################################################
#                 # Prüfen, welche Layer geladen werden
#                 #########################################################
#                 print(fertig)
#                 if sz == 1:
#
#                     #ERgebnis
#                     if projekt != None:
#                         vekwr('gpkg',aus_verz,erg,'projekt_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'projekt_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/projekt_' + zeit + '.gpkg')
#
#                     elif zaehler != None:
#                         vekwr('gpkg',aus_verz,erg,'zaehler_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'zaehler_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/zaehler_' + zeit + '.gpkg')
#
#                     elif flur != None:
#                         vekwr('gpkg',aus_verz,erg,'flur_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'flur_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/flur_' + zeit + '.gpkg')
#
#                     elif gemarkung != None:
#                         vekwr('gpkg',aus_verz,erg,'gemarkung_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'gemarkung_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/gemarkung_' + zeit + '.gpkg')
#
#                     elif gemeinde != None:
#                         vekwr('gpkg',aus_verz,erg,'gemeinde_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'gemeinde_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/gemeinde_' + zeit + '.gpkg')
#
#                     elif gebiet != None:
#                         vekwr('gpkg',aus_verz,erg,'gebiet_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'gebiet_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/gebiet_' + zeit + '.gpkg')
#
#                     elif landkreis != None:
#                         vekwr('gpkg',aus_verz,erg,'landkreis_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'landkreis_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/landkreis_' + zeit + '.gpkg')
#
#                     elif bezirk != None:
#                         vekwr('gpkg',aus_verz,erg,'bezirk_' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'bezirk_' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/bezirk_' + zeit + '.gpkg')
#
#                     else:
#                         vekwr('gpkg',aus_verz,erg,'such_erg' + zeit,False)
#                         vekwr('xlsx',aus_verz,erg,'such_erg' + zeit,False)
#                         filepath = os.path.normcase(aus_verz +'/such_erg_' + zeit + '.gpkg')
#
#                 ######################################################
#                 #######################################################
#
#                 #Vektorlayer laden Jagdgenossenschaft,Landwirtschaft
#
#                 print("Suchergebnis_"  + zeit)
#                 print(sz)
#                 canvas = iface.mapCanvas()
#                 #if eigid != ergid:
#                 if sz == 1:
#                     #print('hallo')
#                     erglayer = QgsVectorLayer(filepath, "Suchergebnis_" + zeit, "ogr")
#
#                     project = QgsProject.instance()
#                     project.addMapLayer(erglayer)
#                     #zoomen
#                     slayer = project.mapLayersByName("Suchergebnis_" + zeit)[0]
#
#                     # An die richtige Stelle verschieben
#                     # Ergebniss in die Ergebnisgruppe verschieben
#
#                     root = project.layerTreeRoot()
#                     ziel = (root.findGroup("Ergebnis"))
#
#                     slayer_erg = root.findLayer(slayer.id())
#                     slayer_clone = slayer_erg.clone()
#                     slayer_par = slayer_erg.parent()
#
#                     ziel.insertChildNode(0, slayer_clone)
#                     slayer_par.removeChildNode(slayer_erg)
#
#                     stil_pad = os.path.dirname(__file__) + '/ergebnis.qml'
#                     slayer.loadNamedStyle(stil_pad)
#                     slayer.triggerRepaint()
#
#
#                     root = QgsProject.instance().layerTreeRoot()
#                     root.findLayer(slayer.id()).setItemVisibilityCheckedParentRecursive(True)
#
#                     iface.setActiveLayer(slayer)
#
#                     sourceCrs = slayer.crs()
#                     destCrs = QgsCoordinateReferenceSystem(3035)
#
#                     # zoomen
#                     #canvas.zoomToSelected()
#                     #canvas.zoomToSelected(pacht)
#
#                     extent = slayer.extent()
#
#                     extent = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance()).transformBoundingBox(extent)
#
#                     canvas.setExtent(extent)
#                     canvas.refresh()
#                     iface.setActiveLayer(slayer)
#
#
#
#
#
#                 if pacht_vetragsart != None or pacht_bezeichnung != None:
#                     project = QgsProject.instance()
#                     player = project.mapLayersByName("SuchergebnisPacht_" + zeit)[0]
#
#
#                     # An die richtige Stelle verschieben
#                     # Ergebniss in die Ergebnisgruppe verschieben
#
#                     root = project.layerTreeRoot()
#                     ziel = (root.findGroup("Ergebnis"))
#
#                     player_erg = root.findLayer(player.id())
#                     player_clone = player_erg.clone()
#                     player_par = player_erg.parent()
#
#                     ziel.insertChildNode(0, player_clone)
#                     player_par.removeChildNode(player_erg)
#
#                     stil_pad = os.path.dirname(__file__) + '/ergebnis.qml'
#                     player.loadNamedStyle(stil_pad)
#                     player.triggerRepaint()
#
#
#                     root.findLayer(player.id()).setItemVisibilityCheckedParentRecursive(True)
#
#                     sourceCrs = player.crs()
#                     destCrs = QgsCoordinateReferenceSystem(3035)
#
#                     extent = player.extent()
#
#                     extent = QgsCoordinateTransform(sourceCrs, destCrs, QgsProject.instance()).transformBoundingBox(extent)
#
#                     canvas.setExtent(extent)
#                     canvas.refresh()
#                     iface.setActiveLayer(player)
#                 else:
#                     pass
#
#                 if erg != eigentum:
#                     slayer = project.mapLayersByName("Suchergebnis_" + zeit)[0]
#                     pfadi= slayer.dataProvider().dataSourceUri()
#                     #erglayer.dataProvider().dataSourceUri()
#                     exc_pad = pfadi.replace('gpkg','xlsx')
#
#                     if platform == "linux":
#                         subprocess.call(["xdg-open", aus_verz])
#                         subprocess.call(["xdg-open", exc_pad])
#                     elif platform == "darwin":
#                         subprocess.call(["open", aus_verz])
#                         subprocess.call(["open", exc_pad])
#                     elif platform == "win32":
#                         os.system("start "+ aus_verz)
#                         try:
#                             os.startfile(exc_pad)
#                         except:
#                             pass
#                #canvas.zoomToSelected(erg)


    # Schnell Druck
    def druck_lay(self):
        dat = datetime.now().strftime('%Y_%m_%d')
        ti = datetime.now().strftime('%H_%M')
        zeit = str(dat) + '_' + str(ti)
        '''
        import processing
        qid = QInputDialog()
        title = "Schnelldruck"
        label = "Welches Format?"
        mode = QLineEdit.Normal
        default = "A3"
        Format, ok = QInputDialog.getText(qid, title, label, mode, default) # Eingebenen Verzeichnispfad mit O.K in die Variable inp

        if ok:
        '''

        #import processing
        project = QgsProject.instance()
        lmanager = project.layoutManager()
        lmanager.layouts()
        # layouts_list = lmanager.layouts()
        lm = lmanager

        Layout = 'SDruck'
        layout = lm.layoutByName(Layout)

        #pages = layout.pageCollection()
        #pages.beginPageSizeChange()
        #page = pages.page(0)
        #page.setPageSize('A4',  QgsLayoutItemPage.Landscape)


        #iface.openLayoutDesigner(layout)
        #mapItem = layout.itemById("karte1")
        mapItem = layout.referenceMap()
        canvas = iface.mapCanvas()
        mapItem.setExtent(canvas.extent())

        #Speicherort festlegen
        pdfv = os.path.normcase(QgsProject.instance().homePath())
        #Druck = QtWidgets.QFileDialog.getSaveFileName(filter = "PDF (*.pdf)" ,directory = pdfv)[0]

        port, pdat = os.path.split(QgsProject.instance().fileName())

        # !!! wir verwenden keine Postgres-Db
        # if port == 'postgresql:':
        #     pnam = g.getuser()
        # else:
        #     pnam, pend = os.path.splitext(pdat)

        # Druck = pdfv + '/' + pnam + '_' +  zeit + '.pdf'
        pnam, pend = os.path.splitext(pdat)
        Druck = pdfv + '/' + pnam + '_' +  zeit + '.pdf'

        if Druck != '':
            if len(Druck.lower()) - Druck.lower().rfind('pdf') != 3:
                Druck = os.path.normcase(Druck + '.pdf')
            else:
                Druck = os.path.normcase(Druck)

        # Processing statt exporter
        #'''
        params = {
            'DISABLE_TILED': False,
            'DPI': 300,
            'FILTER_EXPRESSION': '',
            'FORCE_VECTOR': False,
            'GEOREFERENCE': False,
            'INCLUDE_METADATA': False,
            'LAYERS': None,
            'LAYOUT': Layout,
            'SEPARATE_LAYERS': False,
            'SIMPLIFY': True,
            'TEXT_FORMAT': 0,  # Texte immer als Pfade exportieren (empfohlen)
            'OUTPUT': Druck
        }
        processing.run('native:printlayouttopdf', params) #,feedback=f)
        #'''

        # mit exporter
        '''
        exporter = QgsLayoutExporter(layout)
        exporter.exportToPdf(Druck, QgsLayoutExporter.PdfExportSettings())
        '''

        # Clear the message bar when done
        iface.messageBar().clearWidgets()
        iface.messageBar().pushInfo('Info','Gedruckt')

        if platform == "linux":
            subprocess.call(["xdg-open", Druck])
        elif platform == "darwin":
            subprocess.call(["open", Druck])
        elif platform == "win32":
            os.startfile(Druck)
