# -*- coding: utf-8 -*-
"""
Migration von Flurstücksgeometrien von "alkis_container" nach "liegeo"


Created on Fri Mar 15 08:34:20 2024

@author: BerndMarcus
"""


# %% [1] module
# sys
from os import path
import sqlite3
import datetime as dt
import pandas as pd

# QGIS
from qgis.utils import spatialite_connect, iface
from qgis.core import QgsProject, Qgis
# from qgis.gui import Qgis


# Plugin
from .selectfile import SelectFile


# %% [0]
class AlkisImport:

    def import_from_alkis_container(self):


# %% [2] Geodata von Container nach LieGeo

        # Zeitmessung: Start
        timer_start = dt.datetime.now()
        # ------------------------------------------------------------------------------

        # Pfade:
        # Plugin
        plugin_dir = path.normpath(path.dirname(__file__))

        # QGIS-Projektpfad
        dir_proj = QgsProject.instance().readPath("./")

        # LieGeo-Db
        db_liegeo = path.normpath(dir_proj + '/data/liegeo.sqlite')

        # SQL
        dir_sql = path.normpath(plugin_dir + '/sql')
        sql_lg = dir_sql + '/lg__import2liegeo.sql'

        # ALKIS-Container
        #db_alkis_cont = path.normpath(dir_proj
        #                              + '/data/liegeo__alkis_container.sqlite')
        db_alkis_cont = SelectFile('ALKIS-Container').path_db

        # # Weiche
        # if path.exists(db_alkis_cont):
        #     db_alkis_cont  # = db_alkis_cont
        #
        # else:
        #     with sqlite3.connect(db_liegeo) as conn:
        #         cur = conn.execute("""
        #             select datei from t_sys_pfad
        #             where name = 'ALKIS-Container';
        #             """)
        #
        #     db_alkis_cont = str(cur.fetchone()[0])
        #
        #     conn.close()

        '''
        with sqlite3.connect(db_liegeo) as conn:
            # enable extension loading
            conn.enable_load_extension(True)
            conn.load_extension("mod_spatialite")
        """ ERROR -----------------------------------------------------------
            # libspatialite
            lib_spl = path.normpath('C:/OSGeo4W/bin/mod_spatialite.dll')
            conn.load_extension(lib_sp)
            --=> OperationalError: Das angegebene Modul wurde nicht gefunden.
        ------------------------------------------------------------------"""
        '''

        # Import Flurstücks-/Gemarkungsgeometrien und LieMaS-Info
        try:
            conn = spatialite_connect(db_liegeo)
            # with spatialite_connect(db_liegeo) as conn:

            # named styled parameters must be an instance of a dict (
            # or a subclass), which must contain keys for all named parameters;
            # any extra items are ignored

            # Db einhängen: ALKIS-Container in LieGeo
            params = (
                {"db": db_alkis_cont}
            )
            sql_attdb = """
                ATTACH DATABASE (:db) AS cont;
            """
            _ = conn.execute(sql_attdb, params)

            # Import
            with open(sql_lg, 'r') as file:
                sql = file.read()
                _ = conn.executescript(sql)  # Parameter-Aufgeruf unzulässig

            # DataFrame: Fehlerausgabe
            #
            # Fehlerausgabe wird unterdrückt:
            # temp View "tv_lieflst_ljoin_alkis" läuft ins Leere
            # Connection String in Query ist ausgeklammert
            # hier besser eine py Lösung implementieren
            # evtl. mit Parameterübergabe von py nach sql
            df_err = pd.read_sql(
                """
                select a.lfdnr, a.flstkennz
                , substr(a.flstkennz,1,6) as gema_schluessel
                from tv_lieflst_ljoin_alkis as a
                left join cont.st_alkis as b
                on gema_schluessel == b.fk_flstkennz_liemas
                where true
                and a.pk is NULL
                and b.relation is NULL
                ;
                """,
                conn
            )

            # Fehlerprotokoll
            _ = df_err.to_sql("t_sys_error_import", conn, if_exists='replace')

            # Fremd-Db aushängen
            _ = conn.execute('''
                detach cont;
                ''')

            # Db entrümpeln
            _ = conn.executescript('''
                vacuum;
                ''')

            # Db optimieren
            _ = conn.executescript('''
                pragma optimize;
                ''')

        except Exception as e:
            # print('Fehler: ' + str(e))
            # QGIS Nachricht
            iface.messageBar().pushMessage(
                title= 'Fehler:',
                text= str(e),
                level = Qgis.Warning,
                duration = 3
            )

        finally:
            conn.close()

        # ---------------------------------------------------------------------

        # Aktualisierung Kartenansicht
        iface.mapCanvas().refreshAllLayers()

        # Zeitmessung: Ende
        timer_end = dt.datetime.now()

        # self.process_msg = 'Verarbeitungszeit gesamt: ' + str(global_timer_end - global_timer_start)
        # return self.process_msg
        self.process_time = timer_end - timer_start
        return self.process_time

